<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Suno Lyrics Pro — AI Song Generator</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { theme: { extend: { fontFamily: { sans: ['Inter','sans-serif'], mono: ['JetBrains Mono','monospace'] } } } }</script>
    <style>
        /* ══════════════════════════════════════════
           APPLE LIQUID GLASS — DESIGN SYSTEM
        ══════════════════════════════════════════ */
        *, *::before, *::after { box-sizing: border-box; }

        body {
            font-family: 'Inter', sans-serif;
            background: #06030f;
            color: #ffffff;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* — ANIMATED MESH BACKGROUND — */
        .bg-mesh {
            position: fixed; inset: 0; z-index: 0; pointer-events: none;
            background:
                radial-gradient(ellipse 70% 70% at 5% 0%,   rgba(109,40,217,0.60) 0%, transparent 55%),
                radial-gradient(ellipse 60% 60% at 95% 0%,  rgba(236,72,153,0.50) 0%, transparent 50%),
                radial-gradient(ellipse 80% 80% at 50% 115%,rgba(37,99,235,0.45)  0%, transparent 55%),
                radial-gradient(ellipse 35% 35% at 80% 60%, rgba(16,185,129,0.18) 0%, transparent 50%);
        }
        .orb {
            position: fixed; border-radius: 50%; pointer-events: none;
            filter: blur(90px); z-index: 0;
            animation: orb-drift 18s ease-in-out infinite;
        }
        .orb-1 { width:520px;height:520px;background:rgba(124,58,237,0.30);top:-120px;left:-120px;animation-delay:0s; }
        .orb-2 { width:400px;height:400px;background:rgba(236,72,153,0.25);top:-60px;right:-120px;animation-delay:-6s; }
        .orb-3 { width:340px;height:340px;background:rgba(59,130,246,0.22);bottom:-80px;left:35%;animation-delay:-12s; }
        @keyframes orb-drift {
            0%,100%{ transform:translate(0,0) scale(1); }
            33%    { transform:translate(40px,-35px) scale(1.07); }
            66%    { transform:translate(-25px,40px) scale(0.94); }
        }

        /* — LIQUID GLASS PANELS — */
        .glass {
            background: rgba(255,255,255,0.07);
            backdrop-filter: blur(40px) saturate(180%);
            -webkit-backdrop-filter: blur(40px) saturate(180%);
            border: 1px solid rgba(255,255,255,0.14);
            box-shadow:
                0 8px 32px rgba(0,0,0,0.55),
                inset 0 1px 0 rgba(255,255,255,0.18),
                inset 0 -1px 0 rgba(0,0,0,0.15);
        }
        .glass-strong {
            background: rgba(255,255,255,0.10);
            backdrop-filter: blur(60px) saturate(200%);
            -webkit-backdrop-filter: blur(60px) saturate(200%);
            border: 1px solid rgba(255,255,255,0.20);
            box-shadow:
                0 20px 60px rgba(0,0,0,0.65),
                inset 0 1px 0 rgba(255,255,255,0.22),
                inset 0 -1px 0 rgba(0,0,0,0.20);
        }

        /* — BUTTONS — */
        .btn-gradient {
            background: linear-gradient(135deg, rgba(109,40,217,0.90) 0%, rgba(236,72,153,0.90) 100%);
            border: 1px solid rgba(255,255,255,0.28);
            box-shadow: 0 4px 24px rgba(109,40,217,0.45), inset 0 1px 0 rgba(255,255,255,0.30);
            backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4,0,0.2,1);
        }
        .btn-gradient:hover { transform:translateY(-2px); box-shadow:0 8px 32px rgba(109,40,217,0.55),inset 0 1px 0 rgba(255,255,255,0.35); }
        .btn-gradient:active { transform:translateY(0); }

        .btn-glass {
            background: rgba(255,255,255,0.09);
            border: 1px solid rgba(255,255,255,0.17);
            box-shadow: inset 0 1px 0 rgba(255,255,255,0.18), 0 2px 12px rgba(0,0,0,0.28);
            backdrop-filter: blur(20px);
            transition: all 0.2s ease;
        }
        .btn-glass:hover { background:rgba(255,255,255,0.14); border-color:rgba(255,255,255,0.25); }

        /* — INPUTS & SELECTS — */
        .glass-input {
            background: rgba(255,255,255,0.06);
            border: 1px solid rgba(255,255,255,0.13);
            box-shadow: inset 0 2px 8px rgba(0,0,0,0.32);
            color: #ffffff;
            backdrop-filter: blur(10px);
            transition: all 0.2s ease;
        }
        .glass-input:focus {
            outline: none;
            background: rgba(255,255,255,0.10);
            border-color: rgba(139,92,246,0.55);
            box-shadow: inset 0 2px 8px rgba(0,0,0,0.20), 0 0 0 3px rgba(139,92,246,0.22);
        }
        .glass-input::placeholder { color: rgba(255,255,255,0.30); }
        select.glass-input option { background: #1a0d30; color: #fff; }
        select.glass-input optgroup { background: #1a0d30; color: rgba(255,255,255,0.55); }

        /* — MOOD RADIO CARDS — */
        .mood-card { transition: all 0.2s ease; cursor: pointer; }
        .mood-card:has(input:checked) {
            background: rgba(139,92,246,0.20) !important;
            border-color: rgba(139,92,246,0.55) !important;
            box-shadow: inset 0 1px 0 rgba(255,255,255,0.15), 0 0 0 1px rgba(139,92,246,0.35) !important;
        }
        .mood-card:hover { background: rgba(255,255,255,0.10); }
        .mood-dot { transition: all 0.2s ease; }
        .mood-card:has(input:checked) .mood-dot {
            background: linear-gradient(135deg,#7c3aed,#ec4899);
            border-color: rgba(255,255,255,0.5);
            box-shadow: 0 0 8px rgba(139,92,246,0.7);
        }

        /* — TYPOGRAPHY — */
        .text-gradient {
            background: linear-gradient(135deg, #d8b4fe 0%, #f9a8d4 60%, #fde68a 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .text-muted  { color: rgba(255,255,255,0.55); }
        .text-subtle { color: rgba(255,255,255,0.35); }

        /* — BADGES — */
        .badge-primary { background:rgba(139,92,246,0.22); border:1px solid rgba(139,92,246,0.40); color:#c4b5fd; backdrop-filter:blur(8px); }
        .badge-green   { background:rgba(16,185,129,0.18);  border:1px solid rgba(16,185,129,0.35); color:#6ee7b7; }
        .badge-red     { background:rgba(239,68,68,0.15);   border:1px solid rgba(239,68,68,0.32);  color:#fca5a5; }

        /* — LYRICS SECTION TAGS — */
        .tag-badge { background:rgba(139,92,246,0.22); border:1px solid rgba(139,92,246,0.38); color:#c4b5fd; }

        /* — CARD HOVER LIFT — */
        .card-hover { transition: transform 0.3s cubic-bezier(0.4,0,0.2,1); }
        .card-hover:hover { transform: translateY(-5px); }

        /* — SCROLLBAR — */
        ::-webkit-scrollbar { width:5px; }
        ::-webkit-scrollbar-track { background:transparent; }
        ::-webkit-scrollbar-thumb { background:rgba(255,255,255,0.15); border-radius:10px; }
        ::-webkit-scrollbar-thumb:hover { background:rgba(255,255,255,0.25); }
    </style>
</head>
<body>
    <div class="bg-mesh"></div>
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>
    <div class="orb orb-3"></div>

    <div class="relative z-10">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">

            <!-- ── NAVBAR ── -->
            <header class="flex justify-between items-center mb-14">
                <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-3">
                    <div class="w-10 h-10 btn-gradient rounded-2xl flex items-center justify-center shadow-lg">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3"/>
                        </svg>
                    </div>
                    <span class="text-xl font-bold tracking-tight">Suno <span class="text-gradient">Lyrics</span></span>
                </a>

                <nav class="hidden md:flex items-center glass rounded-full px-6 py-2.5 space-x-7 text-sm font-medium">
                    <a href="<?php echo e(route('home')); ?>" class="<?php echo e(request()->routeIs('home') ? 'text-white' : 'text-muted hover:text-white'); ?> transition-colors">Generate</a>
                    <a href="<?php echo e(route('community')); ?>" class="<?php echo e(request()->routeIs('community') ? 'text-white' : 'text-muted hover:text-white'); ?> transition-colors">Community</a>
                    <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('history')); ?>" class="<?php echo e(request()->routeIs('history') ? 'text-white' : 'text-muted hover:text-white'); ?> transition-colors">My Lyrics</a>
                    <?php endif; ?>
                </nav>

                <div class="flex items-center space-x-3">
                    <?php if(auth()->guard()->guest()): ?>
                        <a href="<?php echo e(route('login')); ?>" class="btn-glass px-4 py-2 rounded-full text-sm font-semibold text-white">Sign In</a>
                        <a href="<?php echo e(route('register')); ?>" class="btn-gradient px-4 py-2 rounded-full text-sm font-bold text-white">Sign Up</a>
                    <?php else: ?>
                        <div class="glass flex items-center space-x-2.5 px-4 py-2 rounded-full">
                            <div class="w-2 h-2 rounded-full bg-emerald-400 animate-pulse" style="box-shadow:0 0 6px rgba(52,211,153,0.7)"></div>
                            <span class="text-sm font-semibold" style="color:rgba(255,255,255,0.85)"><?php echo e(auth()->user()->name); ?></span>
                        </div>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn-glass px-4 py-2 rounded-full text-sm font-semibold text-muted hover:text-red-400 transition-colors">Logout</button>
                        </form>
                    <?php endif; ?>
                </div>
            </header>

            <main>
                <?php echo $__env->yieldContent('content'); ?>
            </main>

            <footer class="mt-20 pt-8 text-center text-subtle text-sm" style="border-top:1px solid rgba(255,255,255,0.08)">
                <p>&copy; <?php echo e(date('Y')); ?> Suno Lyrics Pro &nbsp;·&nbsp; Powered by AI &nbsp;·&nbsp; <span class="text-gradient font-semibold">Built with ✨</span></p>
            </footer>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\pc\Documents\sp7\Web Development\Song Lyrics Generator\resources\views/layouts/premium.blade.php ENDPATH**/ ?>