<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\LyricsController;
use App\Http\Controllers\CommunityController;
use Illuminate\Support\Facades\Route;

// Main Lyrics Generator Routes
Route::get('/', [LyricsController::class, 'index'])->name('home');
Route::post('/generate', [LyricsController::class, 'generate'])->name('generate');

// Community (public)
Route::get('/community', [CommunityController::class, 'index'])->name('community');

// Auth-protected Routes
Route::middleware('auth')->group(function () {
    Route::get('/history', [LyricsController::class, 'history'])->name('history');

    // Community interactions
    Route::post('/lyrics/{lyric}/share', [CommunityController::class, 'share'])->name('lyrics.share');
    Route::post('/lyrics/{lyric}/react', [CommunityController::class, 'react'])->name('lyrics.react');

    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
