<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use App\Models\Lyric;
use Illuminate\Support\Facades\Http;

class LyricsTest extends TestCase
{
    use RefreshDatabase;

    public function test_homepage_loads()
    {
        $response = $this->get('/');
        $response->assertStatus(200);
        $response->assertSee('Suno Lyrics');
    }

    public function test_lyric_generation_validation()
    {
        $response = $this->post('/generate', []);
        $response->assertSessionHasErrors(['style']);
    }

    public function test_lyric_generation_success()
    {
        Http::fake([
            'api.groq.com/*' => Http::response([
                'choices' => [
                    [
                        'message' => [
                            'content' => "[Verse 1]\nNeon lights in the rain\n[Chorus]\nCity of dreams"
                        ]
                    ]
                ]
            ], 200)
        ]);

        $response = $this->post('/generate', [
            'style' => 'Pop',
            'theme' => 'City lights',
            'mood' => 'Energetic',
            'length' => 'Short',
            'language' => 'English'
        ]);

        $response->assertStatus(200);
        $response->assertSee('[Verse 1]');
        $response->assertSee('Neon lights');
        
        $this->assertDatabaseHas('lyrics', [
            'style' => 'Pop',
            'theme' => 'City lights'
        ]);
    }
}
