

<?php $__env->startSection('content'); ?>
<div class="grid grid-cols-1 lg:grid-cols-12 gap-8">

    
    <div class="lg:col-span-4 space-y-6">
        <div class="glass rounded-3xl p-6">
            <h2 class="text-lg font-bold mb-6 flex items-center space-x-2">
                <svg class="w-5 h-5" style="color:#c4b5fd" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"/></svg>
                <span>Lyric Settings</span>
            </h2>

            <form action="<?php echo e(route('generate')); ?>" method="POST" class="space-y-5">
                <?php echo csrf_field(); ?>

                
                <div>
                    <label class="block text-xs font-semibold text-muted mb-2 uppercase tracking-wider">Music Style / Genre</label>
                    <select name="style" class="glass-input w-full rounded-xl px-4 py-3 text-sm" style="padding-left:1rem">
                        <option value="Pop">🎵 Pop</option>
                        <option value="Rock">🎸 Rock</option>
                        <option value="Hip-Hop">🎤 Hip-Hop</option>
                        <option value="R&B">🎶 R&amp;B</option>
                        <option value="Electronic">🎛️ Electronic</option>
                        <option value="Country">🤠 Country</option>
                        <option value="Jazz">🎷 Jazz</option>
                        <option value="Classical">🎻 Classical</option>
                        <option value="Heavy Metal">🤘 Heavy Metal</option>
                        <option value="Acoustic">🪕 Acoustic Folk</option>
                        <option value="Lo-fi">☁️ Lo-fi Chill</option>
                        <option value="Cyberpunk">⚙️ Cyberpunk</option>
                    </select>
                </div>

                
                <div>
                    <label class="block text-xs font-semibold text-muted mb-2 uppercase tracking-wider">Theme or Keywords</label>
                    <input type="text" name="theme" placeholder="e.g. neon nights, lost love…"
                        class="glass-input w-full rounded-xl px-4 py-3 text-sm" style="padding-left:1rem"
                        value="<?php echo e(old('theme', $input['theme'] ?? '')); ?>">
                </div>

                
                <div>
                    <label class="block text-xs font-semibold text-muted mb-3 uppercase tracking-wider">Mood</label>
                    <?php
                    $moods = ['Happy'=>'😄','Sad'=>'😢','Energetic'=>'⚡','Reflective'=>'🤔',
                              'Romantic'=>'💖','Angry'=>'🔥','Chill'=>'😌','Mysterious'=>'🌙',
                              'Melancholic'=>'🌧️','Playful'=>'🎉','Nostalgic'=>'🕰️','Confident'=>'💪'];
                    ?>
                    <div class="grid grid-cols-3 gap-2">
                        <?php $__currentLoopData = $moods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m => $emoji): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label class="mood-card glass flex flex-col items-center p-2.5 rounded-xl cursor-pointer relative" style="border-radius:14px">
                            <input type="radio" name="mood" value="<?php echo e($m); ?>" class="hidden"
                                <?php echo e((isset($input['mood']) && $input['mood']==$m) || (!isset($input['mood']) && $m=='Energetic') ? 'checked' : ''); ?>>
                            <span class="mood-dot w-2 h-2 rounded-full border border-white/30 absolute top-2 right-2" style="background:rgba(255,255,255,0.15)"></span>
                            <span class="text-xl mb-1"><?php echo e($emoji); ?></span>
                            <span class="text-[10px] font-semibold text-muted text-center leading-tight"><?php echo e($m); ?></span>
                        </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                
                <div class="grid grid-cols-2 gap-3">
                    <div>
                        <label class="block text-xs font-semibold text-muted mb-2 uppercase tracking-wider">Length</label>
                        <select name="length" class="glass-input w-full rounded-xl px-3 py-2.5 text-xs" style="padding-left:0.75rem">
                            <option value="Short">Short</option>
                            <option value="Medium" selected>Medium</option>
                            <option value="Long">Long</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs font-semibold text-muted mb-2 uppercase tracking-wider">Language</label>
                        <select name="language" class="glass-input w-full rounded-xl px-3 py-2.5 text-xs" style="padding-left:0.75rem">
                            <optgroup label="🌎 Americas">
                                <option value="English">🇺🇸 English</option>
                                <option value="Spanish">🇪🇸 Spanish</option>
                                <option value="Portuguese">🇧🇷 Portuguese</option>
                            </optgroup>
                            <optgroup label="🌍 Europe">
                                <option value="French">🇫🇷 French</option>
                                <option value="German">🇩🇪 German</option>
                                <option value="Italian">🇮🇹 Italian</option>
                                <option value="Dutch">🇳🇱 Dutch</option>
                                <option value="Russian">🇷🇺 Russian</option>
                                <option value="Polish">🇵🇱 Polish</option>
                                <option value="Swedish">🇸🇪 Swedish</option>
                            </optgroup>
                            <optgroup label="🌏 Asia">
                                <option value="Japanese">🇯🇵 Japanese</option>
                                <option value="Korean">🇰🇷 Korean</option>
                                <option value="Mandarin Chinese">🇨🇳 Mandarin</option>
                                <option value="Hindi">🇮🇳 Hindi</option>
                                <option value="Indonesian">🇮🇩 Indonesian</option>
                                <option value="Malay">🇲🇾 Malay</option>
                                <option value="Thai">🇹🇭 Thai</option>
                                <option value="Vietnamese">🇻🇳 Vietnamese</option>
                                <option value="Turkish">🇹🇷 Turkish</option>
                            </optgroup>
                            <optgroup label="🌐 Middle East & Africa">
                                <option value="Arabic">🇸🇦 Arabic</option>
                                <option value="Swahili">🇰🇪 Swahili</option>
                            </optgroup>
                        </select>
                    </div>
                </div>

                <?php if($errors->has('api_error')): ?>
                <div class="p-4 rounded-xl badge-red text-sm"><?php echo e($errors->first('api_error')); ?></div>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <button type="submit" class="w-full py-4 btn-gradient rounded-2xl font-bold text-white flex items-center justify-center space-x-2 text-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                        <span>Generate Lyrics</span>
                    </button>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" class="w-full py-4 btn-glass rounded-2xl font-bold text-white flex items-center justify-center space-x-2 text-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/></svg>
                        <span>Sign In to Generate</span>
                    </a>
                <?php endif; ?>
            </form>
        </div>
    </div>

    
    <div class="lg:col-span-8">
        <div class="glass rounded-3xl p-8 flex flex-col" style="min-height:620px">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-lg font-bold text-gradient">Generated Lyrics</h3>
                <div class="flex space-x-2">
                    <button id="copyBtn" class="btn-glass p-2.5 rounded-xl text-muted hover:text-white transition-colors" title="Copy">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/></svg>
                    </button>
                    <button class="btn-glass p-2.5 rounded-xl text-muted hover:text-white transition-colors" title="Download">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"/></svg>
                    </button>
                </div>
            </div>

            <div id="lyricsContent" class="flex-grow rounded-2xl p-6 font-mono text-sm leading-relaxed overflow-y-auto" style="background:rgba(0,0,0,0.25);border:1px solid rgba(255,255,255,0.07);max-height:520px">
                <?php if(isset($lyrics)): ?>
                    <?php echo nl2br(preg_replace('/\[(.*?)\]/', '<span class="tag-badge px-2 py-0.5 rounded text-xs font-bold mr-1">[$1]</span>', e($lyrics))); ?>

                <?php else: ?>
                    <div class="h-full flex flex-col items-center justify-center text-subtle space-y-4">
                        <svg class="w-16 h-16 opacity-10" fill="currentColor" viewBox="0 0 24 24"><path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z"/></svg>
                        <p class="text-center">Your creative journey starts here.<br>Configure the settings and click Generate.</p>
                    </div>
                <?php endif; ?>
            </div>

            <div class="mt-5 flex items-center justify-between text-xs text-subtle">
                <span>Optimized for Suno AI v3.5 &amp; v4</span>
                <span id="wordCount">0 words</span>
            </div>
        </div>
    </div>
</div>

<script>
const lyricsContainer = document.getElementById('lyricsContent');
const wordCounter = document.getElementById('wordCount');

function b64DecodeUnicode(str) {
    return decodeURIComponent(atob(str).split('').map(c => '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2)).join(''));
}

function restoreFromHistory(encodedContent, count) {
    try {
        const content = b64DecodeUnicode(encodedContent);
        const formatted = content
            .replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')
            .replace(/\[(.*?)\]/g,'<span class="tag-badge px-2 py-0.5 rounded text-xs font-bold mr-1">[$1]</span>')
            .replace(/\n/g,'<br>');
        lyricsContainer.innerHTML = formatted;
        wordCounter.textContent = count + ' words';
        window.scrollTo({ top: lyricsContainer.offsetTop - 100, behavior: 'smooth' });
    } catch(e) { alert('Could not restore lyrics.'); }
}

if (lyricsContainer) {
    const t = lyricsContainer.innerText.trim();
    if (t && !t.includes('creative journey')) wordCounter.textContent = t.split(/\s+/).length + ' words';

    const pending = localStorage.getItem('restore_lyrics');
    if (pending) { localStorage.removeItem('restore_lyrics'); setTimeout(() => restoreFromHistory(pending,'...'), 100); }
}

document.getElementById('copyBtn').addEventListener('click', function() {
    const text = lyricsContainer.innerText;
    if (text && !text.includes('creative journey')) {
        navigator.clipboard.writeText(text).then(() => {
            const orig = this.innerHTML;
            this.innerHTML = '<svg class="w-4 h-4" style="color:#6ee7b7" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>';
            setTimeout(() => this.innerHTML = orig, 2000);
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.premium', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Documents\sp7\Web Development\Song Lyrics Generator\resources\views/lyrics/index.blade.php ENDPATH**/ ?>