

<?php $__env->startSection('content'); ?>


<div class="mb-12 text-center">
    <div class="inline-flex items-center space-x-2 px-4 py-1.5 badge-primary rounded-full text-xs font-bold uppercase tracking-widest mb-5">
        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 14.5v-9l6 4.5-6 4.5z"/></svg>
        <span>Community Stage</span>
    </div>
    <h2 class="text-4xl font-extrabold mb-3">Community <span class="text-gradient">Lyrics</span></h2>
    <p class="text-muted max-w-lg mx-auto text-sm">Discover lyrics created by artists around the world. Like, copy, and get inspired.</p>
</div>

<?php if(session('success')): ?>
    <div class="mb-8 p-4 rounded-2xl text-sm text-center" style="background:rgba(16,185,129,0.12);border:1px solid rgba(16,185,129,0.28);color:#6ee7b7"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
    <?php $__empty_1 = true; $__currentLoopData = $lyrics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lyric): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="group card-hover" id="lyric-card-<?php echo e($lyric->id); ?>">
        <div class="glass rounded-3xl p-6 flex flex-col h-full">
            <div class="flex justify-between items-center mb-4">
                <span class="badge-primary px-2.5 py-1 rounded-lg text-[10px] font-bold uppercase tracking-wider"><?php echo e($lyric->style); ?></span>
                <span class="text-subtle text-[10px]"><?php echo e($lyric->created_at->diffForHumans()); ?></span>
            </div>

            <h4 class="font-bold mb-1.5 text-white/90 group-hover:text-gradient transition-all line-clamp-1">
                <?php echo e($lyric->theme ?: 'Untitled Track'); ?>

            </h4>

            <div class="flex items-center space-x-2 mb-4">
                <div class="w-5 h-5 btn-gradient rounded-full flex items-center justify-center text-[9px] font-bold text-white flex-shrink-0">
                    <?php echo e(strtoupper(substr($lyric->user->name ?? 'A', 0, 1))); ?>

                </div>
                <span class="text-xs text-muted"><?php echo e($lyric->user->name ?? 'Anonymous'); ?></span>
                <span class="text-subtle text-[10px]">·</span>
                <span class="text-subtle text-[9px]"><?php echo e($lyric->mood); ?></span>
            </div>

            <div class="text-[11px] text-muted line-clamp-5 leading-relaxed font-mono flex-grow mb-5" style="background:rgba(0,0,0,0.22);border-radius:14px;padding:14px;border:1px solid rgba(255,255,255,0.06)">
                <?php echo e($lyric->content); ?>

            </div>

            <div class="flex items-center justify-between" style="border-top:1px solid rgba(255,255,255,0.08);padding-top:14px">
                <div class="flex items-center space-x-2">
                    <?php if(auth()->guard()->check()): ?>
                    <button onclick="reactToLyric(<?php echo e($lyric->id); ?>, 'like')" id="like-btn-<?php echo e($lyric->id); ?>"
                        class="flex items-center space-x-1.5 px-3 py-1.5 rounded-xl text-xs font-semibold btn-glass transition-all
                            <?php echo e($lyric->userReaction()->where('type','like')->exists() ? 'text-emerald-400' : 'text-muted hover:text-emerald-400'); ?>">
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5"/></svg>
                        <span id="like-count-<?php echo e($lyric->id); ?>"><?php echo e($lyric->likes()->count()); ?></span>
                    </button>
                    <button onclick="reactToLyric(<?php echo e($lyric->id); ?>, 'dislike')" id="dislike-btn-<?php echo e($lyric->id); ?>"
                        class="flex items-center space-x-1.5 px-3 py-1.5 rounded-xl text-xs font-semibold btn-glass transition-all
                            <?php echo e($lyric->userReaction()->where('type','dislike')->exists() ? 'text-red-400' : 'text-muted hover:text-red-400'); ?>">
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14H5.236a2 2 0 01-1.789-2.894l3.5-7A2 2 0 018.736 3h4.018c.163 0 .326.02.485.06L17 4m-7 10v2a2 2 0 002 2h.095c.5 0 .905-.405.905-.905 0-.714.211-1.412.608-2.006L17 13V4m-7 10h2m5-10h2a2 2 0 012 2v6a2 2 0 01-2 2h-2.5"/></svg>
                        <span id="dislike-count-<?php echo e($lyric->id); ?>"><?php echo e($lyric->dislikes()->count()); ?></span>
                    </button>
                    <?php else: ?>
                    <span class="flex items-center space-x-1 text-xs text-muted">
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5"/></svg>
                        <span><?php echo e($lyric->likes()->count()); ?></span>
                    </span>
                    <?php endif; ?>
                </div>

                <button onclick="copyLyric('<?php echo e(base64_encode($lyric->content)); ?>', this)"
                    class="btn-glass flex items-center space-x-1.5 px-3 py-1.5 rounded-xl text-xs font-semibold text-muted hover:text-white transition-colors">
                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/></svg>
                    <span>Copy</span>
                </button>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="col-span-full py-24 text-center glass rounded-3xl" style="border-style:dashed;border-color:rgba(255,255,255,0.12)">
        <p class="text-muted font-bold text-lg mb-2">The stage is empty!</p>
        <p class="text-subtle text-sm mb-6">Be the first to share your lyrics with the world.</p>
        <?php if(auth()->guard()->check()): ?>
            <a href="<?php echo e(route('history')); ?>" class="inline-flex px-6 py-2.5 btn-gradient rounded-2xl text-sm font-bold text-white">Go to My Lyrics</a>
        <?php else: ?>
            <a href="<?php echo e(route('register')); ?>" class="inline-flex px-6 py-2.5 btn-gradient rounded-2xl text-sm font-bold text-white">Get Started</a>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>

<div class="mt-12"><?php echo e($lyrics->links()); ?></div>

<script>
const csrfToken = '<?php echo e(csrf_token()); ?>';

async function reactToLyric(lyricId, type) {
    <?php if(auth()->guard()->guest()): ?> window.location.href='<?php echo e(route("login")); ?>'; return; <?php endif; ?>
    try {
        const res = await fetch(`/lyrics/${lyricId}/react`, {
            method:'POST',
            headers:{'Content-Type':'application/json','X-CSRF-TOKEN':csrfToken,'Accept':'application/json'},
            body:JSON.stringify({type})
        });
        const data = await res.json();
        document.getElementById(`like-count-${lyricId}`).textContent = data.likes;
        document.getElementById(`dislike-count-${lyricId}`).textContent = data.dislikes;
        const lb = document.getElementById(`like-btn-${lyricId}`);
        const db = document.getElementById(`dislike-btn-${lyricId}`);
        lb.classList.remove('text-emerald-400'); lb.classList.add('text-muted');
        db.classList.remove('text-red-400');     db.classList.add('text-muted');
        if (data.reacted === 'like')    { lb.classList.remove('text-muted'); lb.classList.add('text-emerald-400'); }
        if (data.reacted === 'dislike') { db.classList.remove('text-muted'); db.classList.add('text-red-400'); }
    } catch(e) { console.error(e); }
}

function copyLyric(encoded, btn) {
    const text = decodeURIComponent(atob(encoded).split('').map(c=>'%'+('00'+c.charCodeAt(0).toString(16)).slice(-2)).join(''));
    navigator.clipboard.writeText(text).then(()=>{
        const orig=btn.innerHTML;
        btn.innerHTML='<svg class="w-3.5 h-3.5" style="color:#6ee7b7" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg><span style="color:#6ee7b7">Copied!</span>';
        setTimeout(()=>btn.innerHTML=orig,2000);
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.premium', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Documents\sp7\Web Development\Song Lyrics Generator\resources\views/community/index.blade.php ENDPATH**/ ?>