

<?php $__env->startSection('content'); ?>
<div class="mb-10">
    <h2 class="text-3xl font-extrabold mb-2">My <span class="text-gradient">Lyrics</span></h2>
    <p class="text-muted">Every masterpiece you've created. Share your favorites with the community.</p>
</div>

<?php if(session('success')): ?>
    <div class="mb-8 p-4 rounded-2xl text-sm text-center" style="background:rgba(16,185,129,0.12);border:1px solid rgba(16,185,129,0.28);color:#6ee7b7"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-5">
    <?php $__empty_1 = true; $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="group card-hover">
        <div class="glass rounded-3xl p-5 flex flex-col h-full" style="border-radius:20px">
            <div class="flex justify-between items-start mb-3">
                <span class="badge-primary px-2.5 py-1 rounded-lg text-[10px] font-bold uppercase tracking-wider"><?php echo e($item->style); ?></span>
                <div class="flex items-center space-x-2">
                    <?php if($item->is_shared): ?>
                        <span class="badge-green px-2 py-0.5 rounded-md text-[9px] font-bold uppercase">Shared</span>
                    <?php endif; ?>
                    <span class="text-subtle text-[9px]"><?php echo e($item->created_at->format('M d')); ?></span>
                </div>
            </div>

            <h4 class="font-bold mb-2 text-sm text-white/90 line-clamp-1"><?php echo e($item->theme ?: 'Untitled track'); ?></h4>

            <div class="text-[11px] text-muted line-clamp-5 leading-relaxed font-mono flex-grow mb-4" style="background:rgba(0,0,0,0.2);border-radius:12px;padding:10px;border:1px solid rgba(255,255,255,0.06)">
                <?php echo e($item->content); ?>

            </div>

            <div style="border-top:1px solid rgba(255,255,255,0.08);padding-top:12px">
                <div class="flex items-center justify-between mb-2.5">
                    <span class="text-subtle text-[9px]"><span class="font-semibold" style="color:rgba(255,255,255,0.5)"><?php echo e($item->mood); ?></span> · <?php echo e($item->language); ?></span>
                    <?php if($item->is_shared): ?>
                    <span class="flex items-center space-x-1 text-[9px]" style="color:#6ee7b7">
                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5"/></svg>
                        <span><?php echo e($item->likes()->count()); ?></span>
                    </span>
                    <?php endif; ?>
                </div>
                <div class="flex space-x-2">
                    <button onclick="copyToClipboard(`<?php echo e(base64_encode($item->content)); ?>`)"
                        class="flex-1 btn-glass flex items-center justify-center space-x-1 py-2 rounded-xl text-xs font-semibold text-white/70 hover:text-white">
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"/></svg>
                        <span>Copy</span>
                    </button>
                    <a href="<?php echo e(route('home')); ?>" onclick="localStorage.setItem('restore_lyrics','<?php echo e(base64_encode($item->content)); ?>')"
                        class="btn-glass flex items-center justify-center p-2 rounded-xl text-white/70 hover:text-white">
                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                    </a>
                    <form method="POST" action="<?php echo e(route('lyrics.share', $item)); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit"
                            class="btn-glass flex items-center justify-center p-2 rounded-xl transition-all <?php echo e($item->is_shared ? 'text-emerald-400' : 'text-white/70 hover:text-emerald-400'); ?>"
                            title="<?php echo e($item->is_shared ? 'Remove from Community' : 'Share to Community'); ?>">
                            <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/></svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="col-span-full py-24 text-center glass rounded-3xl" style="border-style:dashed;border-color:rgba(255,255,255,0.12)">
        <p class="text-muted font-medium mb-4">Your archive is empty.</p>
        <a href="<?php echo e(route('home')); ?>" class="inline-flex px-6 py-2.5 btn-gradient rounded-2xl text-sm font-bold text-white">Create Your First Lyric</a>
    </div>
    <?php endif; ?>
</div>

<div class="mt-12"><?php echo e($history->links()); ?></div>

<script>
function copyToClipboard(encoded) {
    const text = decodeURIComponent(atob(encoded).split('').map(c => '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2)).join(''));
    navigator.clipboard.writeText(text);
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.premium', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Documents\sp7\Web Development\Song Lyrics Generator\resources\views/lyrics/history.blade.php ENDPATH**/ ?>