<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Suno Lyrics Pro') }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { theme: { extend: { fontFamily: { sans: ['Inter','sans-serif'] } } } }</script>
    <style>
        body { font-family:'Inter',sans-serif; background:#06030f; color:#fff; min-height:100vh; }

        .bg-mesh {
            position:fixed; inset:0; z-index:0; pointer-events:none;
            background:
                radial-gradient(ellipse 70% 70% at 5% 0%,  rgba(109,40,217,0.60),transparent 55%),
                radial-gradient(ellipse 60% 60% at 95% 0%, rgba(236,72,153,0.50),transparent 50%),
                radial-gradient(ellipse 80% 80% at 50% 115%,rgba(37,99,235,0.45),transparent 55%);
        }
        .orb { position:fixed; border-radius:50%; pointer-events:none; filter:blur(90px); z-index:0; animation:orb-drift 18s ease-in-out infinite; }
        .orb-1 { width:520px;height:520px;background:rgba(124,58,237,0.30);top:-120px;left:-120px;animation-delay:0s; }
        .orb-2 { width:400px;height:400px;background:rgba(236,72,153,0.25);top:-60px;right:-120px;animation-delay:-6s; }
        .orb-3 { width:340px;height:340px;background:rgba(59,130,246,0.22);bottom:-80px;left:35%;animation-delay:-12s; }
        @keyframes orb-drift {
            0%,100%{ transform:translate(0,0) scale(1); }
            33%    { transform:translate(40px,-35px) scale(1.07); }
            66%    { transform:translate(-25px,40px) scale(0.94); }
        }

        .glass-card {
            background: rgba(255,255,255,0.09);
            backdrop-filter: blur(60px) saturate(200%);
            -webkit-backdrop-filter: blur(60px) saturate(200%);
            border: 1px solid rgba(255,255,255,0.20);
            box-shadow: 0 20px 60px rgba(0,0,0,0.65), inset 0 1px 0 rgba(255,255,255,0.22), inset 0 -1px 0 rgba(0,0,0,0.20);
        }

        .btn-gradient {
            background: linear-gradient(135deg, rgba(109,40,217,0.90), rgba(236,72,153,0.90));
            border: 1px solid rgba(255,255,255,0.28);
            box-shadow: 0 4px 24px rgba(109,40,217,0.45), inset 0 1px 0 rgba(255,255,255,0.30);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }
        .btn-gradient:hover { transform:translateY(-2px); box-shadow:0 8px 32px rgba(109,40,217,0.55),inset 0 1px 0 rgba(255,255,255,0.35); }

        .btn-glass {
            background: rgba(255,255,255,0.09);
            border: 1px solid rgba(255,255,255,0.17);
            box-shadow: inset 0 1px 0 rgba(255,255,255,0.18), 0 2px 12px rgba(0,0,0,0.28);
            backdrop-filter: blur(20px);
            transition: all 0.2s ease;
        }
        .btn-glass:hover { background:rgba(255,255,255,0.14); }

        .glass-input {
            background: rgba(255,255,255,0.07);
            border: 1px solid rgba(255,255,255,0.14);
            box-shadow: inset 0 2px 8px rgba(0,0,0,0.32);
            color: #ffffff;
            width: 100%;
            padding: 0.78rem 1rem 0.78rem 2.85rem;
            border-radius: 0.875rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }
        .glass-input:focus {
            outline: none;
            background: rgba(255,255,255,0.11);
            border-color: rgba(139,92,246,0.55);
            box-shadow: inset 0 2px 8px rgba(0,0,0,0.20), 0 0 0 3px rgba(139,92,246,0.22);
        }
        .glass-input::placeholder { color: rgba(255,255,255,0.32); }

        .text-gradient {
            background: linear-gradient(135deg, #d8b4fe, #f9a8d4);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .text-muted { color: rgba(255,255,255,0.52); }
        .field-error { color: #fca5a5; font-size: 0.75rem; margin-top: 0.5rem; }
        .divider-line { border-color: rgba(255,255,255,0.12); }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen p-4">
    <div class="bg-mesh"></div>
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>
    <div class="orb orb-3"></div>

    <div class="w-full max-w-md relative z-10">
        <!-- Brand -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}" class="inline-flex items-center space-x-3 group">
                <div class="w-12 h-12 btn-gradient rounded-2xl flex items-center justify-center">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3"/>
                    </svg>
                </div>
                <span class="text-2xl font-bold tracking-tight">Suno <span class="text-gradient">Lyrics</span></span>
            </a>
        </div>

        <!-- Glass Card -->
        <div class="glass-card rounded-3xl p-8">
            {{ $slot }}
        </div>

        <p class="text-center mt-6 text-sm text-muted">
            <a href="{{ route('home') }}" class="hover:text-white transition-colors inline-flex items-center space-x-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
                <span>Back to generator</span>
            </a>
        </p>
    </div>
</body>
</html>
