<x-guest-layout>
    <div class="mb-8">
        <h1 class="text-2xl font-bold tracking-tight mb-1">Start creating</h1>
        <p class="text-muted text-sm">Join thousands of AI-powered songwriters.</p>
    </div>

    <form method="POST" action="{{ route('register') }}" class="space-y-5">
        @csrf

        <div>
            <label class="block text-sm font-semibold text-muted mb-2">Artist Name</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="w-4 h-4 text-muted" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                </div>
                <input id="name" type="text" name="name" value="{{ old('name') }}" required autofocus class="glass-input" placeholder="Your artist name">
            </div>
            @error('name')<p class="field-error">{{ $message }}</p>@enderror
        </div>

        <div>
            <label class="block text-sm font-semibold text-muted mb-2">Email Address</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="w-4 h-4 text-muted" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                </div>
                <input id="email" type="email" name="email" value="{{ old('email') }}" required class="glass-input" placeholder="your@email.com">
            </div>
            @error('email')<p class="field-error">{{ $message }}</p>@enderror
        </div>

        <div>
            <label class="block text-sm font-semibold text-muted mb-2">Password</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="w-4 h-4 text-muted" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/></svg>
                </div>
                <input id="password" type="password" name="password" required class="glass-input" placeholder="Min. 8 characters">
            </div>
            @error('password')<p class="field-error">{{ $message }}</p>@enderror
        </div>

        <div>
            <label class="block text-sm font-semibold text-muted mb-2">Confirm Password</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="w-4 h-4 text-muted" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                </div>
                <input id="password_confirmation" type="password" name="password_confirmation" required class="glass-input" placeholder="Repeat password">
            </div>
            @error('password_confirmation')<p class="field-error">{{ $message }}</p>@enderror
        </div>

        <button type="submit" class="w-full py-3.5 btn-gradient rounded-2xl font-bold text-white flex items-center justify-center space-x-2">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
            <span>Create Account</span>
        </button>
    </form>

    <div class="relative my-6">
        <div class="absolute inset-0 flex items-center"><div class="w-full" style="border-top:1px solid rgba(255,255,255,0.10)"></div></div>
        <div class="relative flex justify-center"><span class="px-4 text-xs text-muted" style="background:rgba(10,6,22,0.5)">Already have an account?</span></div>
    </div>

    <a href="{{ route('login') }}" class="w-full py-3 btn-glass rounded-2xl font-semibold text-sm text-white flex items-center justify-center space-x-2">
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/></svg>
        <span>Sign in instead</span>
    </a>
</x-guest-layout>
