<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('lyric_reactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lyric_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['like', 'dislike']);
            $table->timestamps();

            // Each user can only react once per lyric
            $table->unique(['lyric_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('lyric_reactions');
    }
};
